#version 330
#extension GL_EXT_gpu_shader4 : enable
// Julia Set Animated with StocksMod01.fsh  by   c0rymcg

//https://www.shadertoy.com/view/Nd2cWR
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//based on https://www.shadertoy.com/view/WlcXR4

const float PI=3.14159;
const float TAU=6.28318;
vec2 f(vec2 x, vec2 c) {
    return mat2(x,-x.y,x.x)*x + c;
}

vec3 palette(float loc, vec3 a, vec3 b, vec3 c, vec3 d) {
    return a + b*cos( TAU*(c*loc+d) );
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    uv -= 0.5;uv *= 1.3;uv += 0.5;
    vec4 col = vec4(1.0);
    float time = iTime;
    
    int u_maxIterations = 200;
    
    //select a point along the cartoid for C
    float angle = mod(time/3.,TAU*2.);
    bool type1 = true;
    
    vec2 c = vec2(-1,0);
    if (angle < PI){type1 = false;}
    if (angle > TAU+PI){type1=false;}
    float a = mod(angle,TAU);
    
    if (type1==true){c = vec2(cos(a),sin(a))/2.01 - vec2(cos(a*2.),sin(a*2.))/4.02;}
	else{c = vec2(cos(PI-a)/4.01-1.,sin(PI-a)/4.01);}
    
    vec2 z = vec2(0.);
    z.x = 3.0 * (uv.x - 0.5);
    z.y = 2.0 * (uv.y - 0.5);
    bool escaped = false;
    int iterations;
    float sum = 0.;
    float closest=1000.;
    for (int i = 0; i < u_maxIterations; i++) {
        //if (i > u_maxIterations) break;
        iterations = i;
        z = f(z, c);
        sum += max(0.,1.5 - length(z));
        float zangle=atan(z.x, z.y);
        
        float zdist = length(z);
        
        
        closest = min(closest, min(abs(cos(zangle+a)*zdist), abs(sin(zangle+a)*zdist)));
        
        if (dot(z,z) > 4.0) {
            escaped = true;
            //break;
        }
    }
			
    vec3 iterationCol = vec3(palette(closest/2., vec3(0.5),vec3(0.5),vec3(1.0, 1.0, 0.0),vec3(0.3, 0.2, 0.2)));
		
	vec3 coreCol = vec3(palette(sum/10., vec3(0.5),vec3(0.5),vec3(1.0, 1.0, 1.0),vec3(0.3, 0.2, 0.2)));
	
    float f_ite = float(iterations);
    float f_maxIte = float(u_maxIterations);
    gl_FragColor = vec4(escaped ? iterationCol : coreCol, f_ite/f_maxIte );
}
